/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.panel.AnalogMathsPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class OperatorOptionsPanel
extends JPanel {
    ValueOrItemReference fValue;
    EditableNumericSpinner fIntValueField;
    JToggleButton fReferenceButton = null;
    protected JComboBox fOpPRIList;
    protected JComboBox fOperatorList;
    protected JPanel fInputPanel;
    protected CardLayout fInputManager;
    private int fOperator;
    private int fOpPRI;
    private String[] opItem = new String[]{"+", "-", "\u00d7", "\u00f7"};
    private String[] priItem = new String[]{"L", "M", "H"};
    private int id = 0;
    private AnalogMathsPanel parentPanel = null;
    private int previousPRICode;

    public OperatorOptionsPanel(int id, AnalogMathsPanel parentPanel) {
        this.id = id;
        this.parentPanel = parentPanel;
        this.initialize();
    }

    protected void initialize() {
        int i;
        this.setLayout(new GridBagLayout());
        this.fInputManager = new CardLayout(1, 1);
        this.fInputPanel = new JPanel(this.fInputManager);
        this.add(this.fInputPanel);
        JPanel intPanel = new JPanel(new FlowLayout(2));
        this.fOperatorList = new JComboBox();
        for (i = 0; i < this.opItem.length; ++i) {
            this.fOperatorList.addItem(this.opItem[i]);
        }
        this.add(this.fOperatorList);
        this.add(new JLabel(Language.getString("dialog.parameter.analogMaths.pri", "PRI") + " " + String.valueOf(this.id + 1) + " "));
        this.fOperatorList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.fOpPRIList = new JComboBox();
        for (i = 0; i < this.priItem.length; ++i) {
            this.fOpPRIList.addItem(this.priItem[i]);
        }
        this.add(this.fOpPRIList);
        this.fOpPRIList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (OperatorOptionsPanel.this.parentPanel != null) {
                    for (int i = 0; i < OperatorOptionsPanel.this.parentPanel.getOperatorOptionsPanel().length; ++i) {
                        if (OperatorOptionsPanel.this.getID() == i || OperatorOptionsPanel.this.parentPanel.getOperatorOptionsPanel(i).getCurrentOpPRICode() != OperatorOptionsPanel.this.getCurrentOpPRICode()) continue;
                        OperatorOptionsPanel.this.parentPanel.getOperatorOptionsPanel(i).setCurrentOpPRICode(OperatorOptionsPanel.this.getPreviousPRICode());
                        OperatorOptionsPanel.this.setPreviousPRICode(OperatorOptionsPanel.this.getCurrentOpPRICode());
                    }
                }
            }
        });
    }

    public void setPreviousPRICode(int priCode) {
        this.previousPRICode = priCode;
    }

    public int getPreviousPRICode() {
        return this.previousPRICode;
    }

    public int getID() {
        return this.id;
    }

    public void setParentPanel(AnalogMathsPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public void setOperator(int operator) {
        this.fOperator = operator;
    }

    public int getOpPRI() {
        return this.fOpPRI;
    }

    public void setOpPRI(int opPRI) {
        this.fOpPRI = opPRI;
    }

    public int getCurrentOperatorCode() {
        return this.fOperatorList.getSelectedIndex();
    }

    public String getCurrentOperator() {
        return this.fOperatorList.getSelectedItem().toString();
    }

    public int getCurrentOpPRICode() {
        return this.fOpPRIList.getSelectedIndex();
    }

    public String getCurrentOpPRI() {
        return this.fOpPRIList.getSelectedItem().toString();
    }

    public void setCurrentOpPRICode(int priCode) {
        this.fOpPRIList.setSelectedIndex(priCode);
        this.setOpPRI(priCode);
        this.setPreviousPRICode(priCode);
    }

    public void setCurrentOperatorCode(int operatorCode) {
        this.fOperatorList.setSelectedIndex(operatorCode);
        this.setOperator(operatorCode);
    }

    protected void setLabels() {
        this.fReferenceButton.setText(Language.getString("integerOrReferencePanel.referenceButtonText", "Reference"));
    }

    public boolean checkValue(boolean b) {
        return this.fIntValueField.checkValue(b);
    }

    public boolean checkChanged() {
        return this.getOperator() != this.getCurrentOperatorCode() || this.getOpPRI() != this.getCurrentOpPRICode();
    }

    protected boolean equalItems(ParameterItem item1, ParameterItem item2) {
        return item1.getParameterNumber() == item2.getParameterNumber() && item1.getParameter().getBlock().getNumber() == item2.getParameter().getBlock().getNumber();
    }

    public IntegerOrBlockReference getValue() {
        IntegerOrBlockReference result = new IntegerOrBlockReference();
        return result;
    }

    protected void setReference(boolean referenceEnabled) {
        if (referenceEnabled) {
            this.fInputManager.last(this.fInputPanel);
        } else {
            this.fInputManager.first(this.fInputPanel);
        }
        this.validate();
    }

    protected void referenceButtonPressed(boolean b) {
        this.setReference(this.fReferenceButton.isSelected());
    }

    public class ReferenceButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            OperatorOptionsPanel.this.referenceButtonPressed(OperatorOptionsPanel.this.fReferenceButton.isSelected());
        }
    }
}

